// script.cpp : Defines the class behaviors for the application.
//
//const GUID CDECL BASED_CODE _tlid =
//		{ 0xB036D113, 0x15EF, 0x11D2, { 0x85, 0x2d, 0x2e, 0x9e, 0x34, 0,0,0 } };
//const WORD _wVerMajor = 1;
//const WORD _wVerMinor = 0;

#include "stdafx.h"
#include "script.h"

#include "MainFrm.h"
#include "scriptDoc.h"
#include "scriptView.h"
#include "ScriptEngine.h"
#include "RegisterDialog.h"
#include "utility.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////////////
////////////////////// GLOBALS ////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
class CScriptEngine *pENGINE;

bool gbLaunching=false; //used to track the launching process.  Flipped to false by file-open code to signify that a file was actually opened.
bool gbSquelchAutoLaunch=false; //**MARCH99 new - if this is true, we're forcing "edit" mode even though we're launching with a file, because we launched with our special "magic" temp file
bool gbForceAllowOpen=false;  //used by chain to allow the opening of a file even in RUNTIME mode 
bool gbEnterModalLoop=false;
bool gbFileHasValidChecksum=false;
bool gbScrollToError=true;
bool gbHasPrefsFile=false;	// true iff prefs file is there
int giCustNum = 0;
HWND ghwndMain;
CWnd *gpcwndMain;
BOOL gbScriptRunning=false;
BOOL gbQuitting=false;
UINT giNextMenuID=kBaseMenuID;
HCURSOR ghCursorNormal=NULL;
unsigned long giSerialNumber=0;
DWORD gdwPrefFlags=1;

BOOL gbTrace=false;
BOOL gbStep=false;

LaunchModeType gLaunchMode=LM_INVALID;
TCHAR gszRealFilename[MAX_PATH+1];   //used when opening the magic file to hold the real path..

CScriptDoc *gpCurrentDocument=0;

//permission flags
bool gbShowEditorWindow=false;	//Is the main window shown?
bool gbAllowEmptyLaunch=false;	//Can the app be launched without a file?
bool gbCanOpenPlainFiles=false; //Can we open non-checksummed files?
bool gbCloseOnEnd=false;		//Does entire app close when program exits?
bool gbAllowSave=false;			//Can apps be saved?
bool gbProtectedFile=true;		//Is the file protected (not editable?)
TCHAR gszSerialNumber[64];
wchar_t gszLastPath[MAX_PATH+1];

#ifdef _POCKET
#if defined(_WIN32_WCE_PSPC) && (_WIN32_WCE >= 300)
#define STRIKENUM_MAX 3

typedef struct _FindAppT
{
	TCHAR *pzExeName;
	HWND hwnd;
	TCHAR *pzNsbName;
} FindAppT, *pFindAppT;

BOOL CALLBACK FindApplicationWindowProc(HWND hwnd, LPARAM lParam)
{
	DWORD		dwProcessID;
	INT		    iLen;
	TCHAR	    szTempName[MAX_PATH]=TEXT("\0");
	pFindAppT	pFindApp=(pFindAppT)lParam;

	::GetWindowThreadProcessId(hwnd,&dwProcessID);
	if (!dwProcessID)
		return TRUE;

	iLen=::GetModuleFileName((HMODULE)dwProcessID,szTempName,MAX_PATH);
	if (!iLen) 
		return TRUE;

	if( pFindApp->pzNsbName )
	{
		TCHAR szWindowText[MAX_PATH] = _T( "\0" );
		// Get the window text to use as a psuedo-executable name
		::GetWindowText( hwnd, szWindowText, MAX_PATH );
		if( !_tcsicmp( szWindowText, pFindApp->pzNsbName ) )
		{
			pFindApp->hwnd = hwnd;
			return FALSE;
		}
	}
	else
	{
		TCHAR *psz;
		psz = _tcsrchr( szTempName, _T( '\\' ) );
		if( ( _tcsicmp( szTempName, pFindApp->pzExeName ) == 0 ) || ( psz && !_tcsicmp( psz, _T( "\\VNSB.exe" ) ) ) )
		{
			pFindApp->hwnd=hwnd;		
			return FALSE;
		}
	}

	return TRUE;
}
#endif
#endif

/////////////////////////////////////////////////////////////////////////////
// CScriptApp

BEGIN_MESSAGE_MAP(CScriptApp, CWinApp)
	//{{AFX_MSG_MAP(CScriptApp)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptApp construction

//vc6fix
//CScriptApp::CScriptApp(LPCTSTR lpszAppName, LPCTSTR lpszHelpName)
//	: CWinApp(lpszAppName, lpszHelpName)
#if(_WIN32_WCE != 200)  //**MARCH99 - only HPC has help name in constructor
CScriptApp::CScriptApp(LPCTSTR lpszAppName)
	: CWinApp(lpszAppName)//, lpszHelpName)
#else
CScriptApp::CScriptApp(LPCTSTR lpszAppName, LPCTSTR lpszHelpName)
	: CWinApp(lpszAppName, lpszHelpName)
#endif
{
//   CString strMessage;
//   strMessage.Format( _T( "Constructor '%s'" ), theApp.m_pszAppName );
//   AfxMessageBox( strMessage );
	//**JUNE99
   //MessageBox(0,TEXT("CScriptApp constructor"),TEXT(""),MB_OK);
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CScriptApp object

// WCE MFC apps require the application name to be specified in the CWinApp 
// constructor. A help contents filename may also be specified.

//CScriptApp theApp(_T("NSBasic"), _T("NSBasic.htc"));
//vb6fix
#if(_WIN32_WCE != 200)  //**MARCH99 - only HPC has help name in constructor
CScriptApp theApp(_T("NSBasic"));
#else
CScriptApp theApp(_T("NSBasic"), _T("NSBasic.htc"));
#endif

#if 1 //!defined(_WIN32_WCE_PSPC)


/////////////////////////////////////////////////////////////////////////////
// 
/////////////////////////////////////////////////////////////////////////////
TCHAR* mywce_GetNextArg( TCHAR* pszArgList, TCHAR szArg[] )
{

	TCHAR*  pszSpace     = NULL;
	TCHAR*  pszTab       = NULL;
	TCHAR*  pszNextArg   = NULL;
	LPTSTR  pszArg       = &szArg[0];
	int     iWhiteCount  = 0;
	bool	bInQuote;

	if ((pszArgList == NULL) || (lstrlen(pszArgList) == 0))
		return (NULL);


	// count white space
	iWhiteCount = 0;
	pszSpace    = &pszArgList[0];
	while ((*pszSpace == (short)' ') || (*pszSpace== (short)'\t'))
	{
		pszSpace++;
		iWhiteCount++;
	}

	//skip the quote, if any
	if(*pszSpace==TEXT('"'))
	{
		bInQuote=true;
		iWhiteCount++;
		pszSpace++;
	}
	else
		bInQuote=false;

	// copy next arg to szArg
	lstrcpy( szArg, &pszArgList[iWhiteCount] );
	pszArg = &szArg[0];

	
	if(bInQuote)
	{
		TCHAR *pszQuote=0;

		pszQuote=_tcschr(szArg,TEXT('"'));
		if(pszQuote)
		{
			*pszQuote=0;
			pszNextArg=pszQuote+1;
		}
		else
			pszNextArg=&szArg[lstrlen(szArg)+1];

	}
	else
	{
		// null-terminate it
		// point pszNextArg at next arg
		pszSpace = _tcschr( szArg, (int)' ' );
		pszTab   = _tcschr( szArg, (int)'\t' );
		if ((pszSpace == NULL) && (pszTab != NULL))
		{
			pszSpace = pszTab;
		}
		else if ((pszSpace != NULL) && (pszTab != NULL))
		{
			if (pszTab < pszSpace)
				pszSpace = pszTab;
		}
		if (pszSpace)
		{
			*pszSpace = 0;
			pszNextArg = pszSpace + 1;
		}
		else
			pszNextArg = &szArg[lstrlen(szArg)+1];
	}
	// check that we have a valid arg
	ASSERT(pszArg);

	// return pointer to beginning of next arg in list
	return (pszNextArg);
}



/////////////////////////////////////////////////////////////////////////////
// 
/////////////////////////////////////////////////////////////////////////////
int mywce_GetArgCount( TCHAR* pszArgList )
{

	TCHAR*  pszSpace     = NULL;
	TCHAR*  pszTab       = NULL;
	TCHAR*  pszNextArg   = NULL;
	int     iWhiteCount  = 0;
	int     iArgCount    = 0;
	bool	bInQuote;

	
	if ((pszArgList == NULL) || (lstrlen(pszArgList) == 0))
		return (0);

	iArgCount  = 0;
	pszNextArg = pszArgList;
	while (pszNextArg != NULL)
	{
		// gobble/count white space
		iWhiteCount = 0;
		pszSpace    = pszNextArg;
		while ((*pszSpace == (short)' ') || (*pszSpace == (short)'\t'))
		{
			pszSpace++;
			iWhiteCount++;
		}
		//skip the quote, if any
		if(*pszSpace==TEXT('"'))
		{
			bInQuote=true;
			iWhiteCount++;
			pszSpace++;
		}
		else
			bInQuote=false;

		// point pszNextArg past the white space
		pszNextArg = &pszNextArg[iWhiteCount];
		// if its not null, then increment the count
		if (pszNextArg != NULL)
			iArgCount++;

		if(bInQuote)
		{
			TCHAR *pszQuote=0;
			pszQuote = _tcschr(pszNextArg,TEXT('"'));
			if(pszQuote)
				pszNextArg=pszQuote+1;
			else
				break;//done
		}
		else
		{
			// for next iteration, point pszNextArg at next arg
			pszSpace = _tcschr( pszNextArg, (int)' ' );
			pszTab   = _tcschr( pszNextArg, (int)'\t' );
			if ((pszSpace == NULL) && (pszTab != NULL))
			{
				pszSpace = pszTab;
			}
			else if ((pszSpace != NULL) && (pszTab != NULL))
			{
				if (pszTab < pszSpace)
					pszSpace = pszTab;
			}
			if (pszSpace)
				pszNextArg = pszSpace + 1;
			else
				break;  // i.e. we're done
		}
	}

	return (iArgCount);
}
#endif

void CScriptApp::ParseCommandLine(CCommandLineInfo& rCmdInfo)
{
	int iNumFiles=0;

	_tcscpy(gszRealFilename,TEXT(""));
#if defined(_WIN32_WCE)
	int     iArgCount           = mywce_GetArgCount( m_lpCmdLine );
	TCHAR   szTmp[MAX_PATH*2]   = _T("");
	TCHAR*  pszArgList          = m_lpCmdLine;
	LPCTSTR pszParam;
#endif
	{
		//TCHAR szBuf[50];
		//wsprintf(szBuf,L"%i args",iArgCount);
		//MessageBox(0,pszArgList,szBuf,MB_OK);
		if(iArgCount)
			iArgCount--;
	}

#if defined(_WIN32_WCE)
	for (int i = 0; i < iArgCount; i++)
#else
	for (int i = 1; i < __argc; i++)
#endif
	{
#if defined(_WIN32_WCE)
		pszArgList = mywce_GetNextArg( pszArgList, szTmp );

		pszParam = &szTmp[0];
		ASSERT(pszParam);
#else
		LPCTSTR pszParam = __targv[i];
#endif
		BOOL bFlag = FALSE;
#if defined(_WIN32_WCE)
		BOOL bLast = ((i + 1) == iArgCount);
#else
		BOOL bLast = ((i + 1) == __argc);
#endif

		// MMD Tries to make Command line property 2002-10-14
//		m_strCommandLine = m_lpCmdLine;
		m_strCommandLine += pszParam;
		m_strCommandLine += _T(' ');
//MessageBox(0,_T("Command Line"),m_lpCmdLine,MB_OK);

		//MessageBox(0,L"PARSE",pszParam,MB_OK);
		if (pszParam[0] == '-' || pszParam[0] == '/')
		{
			// remove flag specifier
			bFlag = TRUE;
			++pszParam;
		}
		if(!bFlag && _tcslen(pszParam)>0) //not a flag
		{	
			iNumFiles++;
			if( iNumFiles==1 && _tcsicmp(pszParam,kMagicVNSBFileName)==0)
			{//we got our "magic" filename from VNSB.  Open it instead of launching it
			 //by setting a flag, and set the path to the full path of the file..
				pszParam=kMagicVNSBFilePath;

				gbSquelchAutoLaunch=true;
				gbShowEditorWindow=true;
			}
			if(iNumFiles>1) //save off the real filename so we can restore it..
				_tcscpy(gszRealFilename,pszParam);
		}
		if(1)//bFlag && _tcslen(pszParam)>0)
		{
			rCmdInfo.ParseParam(pszParam, bFlag, bLast);
		}
	}

	m_strCommandLine.TrimRight();
}

void SetFlagsForLaunchMode()
{
	switch(gLaunchMode)
	{
	case LM_FULL:
		gbShowEditorWindow=true;
		gbAllowEmptyLaunch=true;
		gbCanOpenPlainFiles=true;
		gbCloseOnEnd=false;
		gbAllowSave=true;
		break;
	case LM_DEMO:
		gbShowEditorWindow=true;
		gbAllowEmptyLaunch=true;
		gbCanOpenPlainFiles=true;
		gbCloseOnEnd=false;
		gbAllowSave=false;
		break;
	case LM_RUNTIME:
		gbShowEditorWindow=false;
		gbAllowEmptyLaunch=false;
		gbCanOpenPlainFiles=false;
		gbCloseOnEnd=true;
		gbAllowSave=false;
		break;
	default:
		gbShowEditorWindow=false;
		gbAllowEmptyLaunch=false;
		gbCanOpenPlainFiles=false;
		gbCloseOnEnd=true;
		gbAllowSave=false;
		break;
	}
}

void doWritePrefsFile(void)
{
	DWORD dwBytesWritten;
	TCHAR szPrefBuf[500];
	char szPrefBufAscii[500];
	TCHAR szPrefSerial[30];
	int iLen;
	HANDLE hFile;
	
	if(gLaunchMode==LM_DEMO)
		_tcscpy(szPrefSerial,TEXT("demo"));
	else
		_tcscpy(szPrefSerial, gszSerialNumber);

	wsprintf(szPrefBuf,TEXT("Serial:%s\nFlags:%lu\nLastDoc:%s\n"),szPrefSerial,gdwPrefFlags,gszLastPath);
	iLen=wcstombs(szPrefBufAscii,szPrefBuf,500);

	hFile=CreateFile(kPrefsPathName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE)
	{
		MessageBox(0,TEXT("Could not open NSBasic/CE prefs file.  Please make sure no other instances of NSBasic/CE are running and try again."),TEXT("Error"),MB_OK);
		return;
	}
	WriteFile(hFile,szPrefBufAscii,iLen,&dwBytesWritten,NULL);
	CloseHandle(hFile);
}

void doWriteDebug(wchar_t *name)
{
#if 0
	DWORD dwBytesWritten;
	TCHAR szPrefBuf[500];
	char szPrefBufAscii[500];
	TCHAR szPrefSerial[30];
	int iLen;
	HANDLE hFile;
	
	if(gLaunchMode==LM_DEMO)
		_tcscpy(szPrefSerial,TEXT("demo"));
	else
		_tcscpy(szPrefSerial, gszSerialNumber);

	wsprintf(szPrefBuf,TEXT("Debug:%s\r\n"),name);
	iLen=wcstombs(szPrefBufAscii,szPrefBuf,500);

	hFile=CreateFile(kDebugPathName,GENERIC_WRITE,0,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE)
	{
		MessageBox(0,TEXT("Could not open NSBasic/CE prefs file.  Please make sure no other instances of NSBasic/CE are running and try again."),TEXT("Error"),MB_OK);
		return;
	}
	SetFilePointer(hFile, 0, NULL, FILE_END);
	WriteFile(hFile,szPrefBufAscii,iLen,&dwBytesWritten,NULL);
	CloseHandle(hFile);
#endif
}


void doReadPrefsFile(void)
{
	HANDLE hFile;
	gbHasPrefsFile = false;

	gszLastPath[0] = 0;

	hFile=CreateFile(kPrefsPathName,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile!=INVALID_HANDLE_VALUE)
	{
		TCHAR szPrefsLine[512];
		TCHAR szPrefsUnicode[512];
		unsigned long iNumBytes;
		TCHAR *pCR,*pText,*pFlags, *pDoc, *pBuf, *pCheck;
		TCHAR strCust[5], strPadded[3];
		int nProduct, nMod, nPad1, nPad2, nCheck;
		unsigned long lCode;

		memset(szPrefsLine,0,sizeof(szPrefsLine));
		if(ReadFile(hFile,szPrefsLine,sizeof(szPrefsLine)-2,&iNumBytes,NULL) && iNumBytes!=0)
		{
			gbHasPrefsFile = true;

			memset(szPrefsUnicode,0,sizeof(szPrefsUnicode));
			mbstowcs(szPrefsUnicode,(char *)szPrefsLine,255);
			pText=szPrefsUnicode;
			while(*pText && _istspace(*pText)) pText++;
			pCR=pText;
			while(*pCR && *pCR!=TEXT('\r') && *pCR!=TEXT('\n')) pCR++;
			if (*pCR)
			{
				pFlags=pCR+1;
				*pCR=0;
			}
			else
			{
				pFlags = pCR;
			}
			_tcslwr(pText);
			pCR = pFlags;
			while(*pCR && *pCR!=TEXT('\r') && *pCR!=TEXT('\n')) pCR++;
			if (*pCR)
			{
				pDoc = pCR + 1;
				*pCR = 0;
			}
			else
			{
				pDoc = pCR;
			}
			_tcslwr(pFlags);
			if(*pFlags && _tcsnicmp(pFlags,TEXT("flags:"),6)==0)
			{
				gdwPrefFlags=_ttol(pFlags+6);
			}
			else
			{
				gdwPrefFlags=0;
			}

			if( _tcscmp( pText, TEXT("serial:demo") ) == 0 )
			{
				giSerialNumber=0;
				gLaunchMode=LM_DEMO;
			}
			else if( _tcscmp( pText, _T("serial:runtime") ) == 0 || _tcscmp( pText, _T("serial:unregistered") ) == 0 )
				gLaunchMode=LM_RUNTIME;
			else if (_tcsncmp(pText,TEXT("serial:"),7)==0)
			{
				// First, skip 'serial:'
				pText += 7;

				if( *pText )
				{
					// Uppercase, Filter out all hyphens, then make sure we have 9 characters
					_tcsupr( pText );
					pBuf = pCheck = pText;
					// Store a copy of the serial number, for display in About Box
					_tcscpy( gszSerialNumber, pText );
					while( *pCheck )
					{
						if( *pCheck != _T('-') )
						{
							*pBuf = *pCheck;
							pBuf++;
						}
						pCheck++;
					}
					*pBuf = _T('\0');

					if( _tcslen( pText ) == 9 )
					{
						// CE product should be 1
						nProduct = *pText - _T('A');
						if( ( nProduct / 6 ) + 1 == 2 )
						{
							nMod = nProduct % 6 + 1;

							// Reconstruct Cust# as a string and then convert to number
							strCust[0] = *( pText + 4 );
							strCust[1] = *( pText + 7 );
							strCust[2] = *( pText + 6 );
							strCust[3] = *( pText + 2 );
							strCust[4] = *( pText + 1 );
							giCustNum = _ttoi( strCust );

							// nCheck should be giCustNum % 23
							nCheck = *( pText + 8 ) - _T('A');
							if( giCustNum % 23 != nCheck )
								giCustNum = 0;
							else
							{
								strPadded[2] = 0;
								// Get pad characters and test
								nPad1 = *( pText + 3 ) - _T('0');
								strPadded[0] = *( pText + 6 ); strPadded[1] = *( pText + 7 );
								if( ( nPad1 + _ttoi( strPadded ) ) % 7 != nMod )
									giCustNum = 0;
								else
								{
									nPad2 = *( pText + 5 ) - _T('0');
									strPadded[0] = *( pText + 1 ); strPadded[1] = *( pText + 2 );
									if( ( nPad2 + _ttoi( strPadded ) ) % 7 != nMod )
										giCustNum = 0;
								}
							}
						}
					}
					if( giCustNum == 0 )
						goto closeFile;
					lCode = giCustNum * 71 + 3000003;
					giSerialNumber = lCode;
				}
				else
				{
					goto closeFile;
				}
				if(isCodeValid(lCode))
					gLaunchMode=LM_FULL;
				else
				{
					MessageBox(::GetForegroundWindow(),TEXT("The serial number does not appear to be valid.  Please check your code and/or re-install."),TEXT("Error"),MB_OK);
					giCustNum = 0;
				}
				/* Search for the last doc */
				if (*pDoc && 0 == _tcsncmp(pDoc, _T("LastDoc:"), 8))
				{
					while ((*pDoc) && ':' != *pDoc) ++pDoc;
					if (*pDoc)
					{
						++pDoc;
						_tcscpy(gszLastPath, pDoc);

						for (pDoc = gszLastPath; ' ' <= *pDoc; ++pDoc) {}
						*pDoc = 0;
					}
				}
			}
		}

closeFile:
		CloseHandle(hFile);
	}
}

// Check serial number
static bool CheckSerialNumber()
{
	doReadPrefsFile();
	if (!gbHasPrefsFile) goto force_runtime_mode;
	if (0 == giCustNum) goto force_runtime_mode;

	// Do force runtime mode here

goto dont_force_runtime_mode;

force_runtime_mode:
	gLaunchMode=LM_RUNTIME;

dont_force_runtime_mode:

	return true;
}

/////////////////////////////////////////////////////////////////////////////
// CScriptApp initialization

BOOL CScriptApp::InitInstance()
{
	CCommandLineInfo cmdInfo;
	COleDateTime dt;
	int month,year;
//   ::MessageBeep( MB_ICONASTERISK );
	//**JUNE99
	//MessageBox(0,TEXT("CScriptApp::InitInstance"),TEXT(""),MB_OK);

/**MARCH99 not sure how long this has been commented out.  Is it necessary?
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}
*/
	giSerialNumber=0;

	gLaunchMode=LM_FULL;

	gdwPrefFlags=0;

	*gszRealFilename=0;
	//ghCursorNormal=SetCursor(LoadCursor(NULL,IDC_WAIT));
	//vc6fix 
	//ghCursorNormal=SetCursor((HICON)LoadImage(NULL, IDC_WAIT,IMAGE_ICON,0,0,LR_DEFAULTCOLOR));
	SetWaitCursor(false);
	//SetCursor(ghCursorNormal);

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("NSBasic"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)


	//read serial # file and determine launch mode
	//goto fool;

	if (!CheckSerialNumber()) return false;

//fool:
	//TIMEOUT CODE
	if(gLaunchMode==LM_DEMO)
	{
		dt=COleDateTime::GetCurrentTime();
		month=dt.GetMonth();
		year=dt.GetYear();

		if(month<3 || month>6 || year!=1999)
		{//**MARCH99 Timeout message removed, but revert-to-runtime behavior remains.  Date pushed to 6/99
			//MessageBox(::GetForegroundWindow(),TEXT("This limited-time version of NS Basic/CE has expired"),TEXT("TIMEOUT"),MB_OK);
			gLaunchMode=LM_RUNTIME;
		}
	}

	SetFlagsForLaunchMode();
	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

#ifdef _POCKET

#if 1
	/* EMP This no longer works properly with Mobile 5, but if it isn't here, it breaks */
	CCeDocListDocTemplate* pDocTemplate;
	pDocTemplate = new CCeDocListDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CScriptDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CScriptView),
		CString( _T( "Scripts (*.nsb)|*.nsb|Text Files (*.txt)|*.txt" ) ) );
  //CString( _T( "Text Files (*.txt)|*.txt" ) ) );
	AddDocTemplate(pDocTemplate);
#endif

	// Parse command line for standard shell commands, DDE, file open
//	CCommandLineInfo cmdInfo;
	cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing;
#else
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CScriptDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CScriptView));
	AddDocTemplate(pDocTemplate);
#endif

	if(mywce_GetArgCount( m_lpCmdLine ) > 0 )
		gbShowEditorWindow=false;
	gbSquelchAutoLaunch=false;

	// Parse command line for standard shell commands, DDE, file open
	//this call will set the gbSquelchAutoLaunch flag if we
	//get the "magic" filename and aren't supposed to run it..
	ParseCommandLine(cmdInfo);

	COleObjectFactory::UpdateRegistryAll();

	//This line doesn't seem to be necessary
	//AfxOleRegisterTypeLib(AfxGetInstanceHandle(), LIBID_Calc, TEXT("Calc.tlb"), NULL);

	//Initialize the script engine..
	pENGINE=new(cScriptEngine);

	// Dispatch commands specified on the command line

	gbLaunching=true;
	gpcwndMain=m_pMainWnd;

//moved up a few lines so I can flip it if we get the VNSB magic filename
//	if(mywce_GetArgCount( m_lpCmdLine ) > 0 )
//		gbShowEditorWindow=false;
//MessageBox( 0, _T("Spider-Man"), _T("HBO"), MB_OK );
	Sleep( 0 );


   BOOL bResult = ProcessShellCommand(cmdInfo);
   if( !bResult )
#ifdef _POCKET
#if 0
	/* EMP this no longer works with Mobile 5 */
   {
      pDocTemplate->ShowDocList();	

      // if there is no file in the doclist, we will create a new one.
      CCeDocList* pDL = pDocTemplate->m_pWndDocList;	
      if (pDL->GetItemCount() == 0) 
      {
         pDL->OnClose();
         OnFileNew();
      }
   }
#endif
#else
		return FALSE;
#endif

	//the gbLaunching flag is set to false if a file was actually opened..

tryAgain:
	if(!gbAllowEmptyLaunch && gbLaunching) //if gbLaunching is flipped, we launched something, else we did not.
	{//flag not flipped, we didn't launch with a document.
		if (gbHasPrefsFile)
		{
			CRegisterDialog dlg;
			if (IDOK == dlg.DoModal())
			{
				wsprintf(gszSerialNumber,TEXT("%s"), dlg.m_serialNumber);

				doWritePrefsFile();

				if (!CheckSerialNumber())
				{
					return false;
				}
				SetFlagsForLaunchMode();
				if (!gbAllowEmptyLaunch) goto tryAgain;

				return false;

				gbCloseOnEnd=false;
				gbShowEditorWindow=true;
				m_pMainWnd->ShowWindow(SW_SHOWNORMAL);
			}
			else
			{
				return false;
			}
		}
		else
		{
			MessageBox(0,TEXT("This is a runtime-only version of NS Basic/CE, and cannot be launched separately.  Launch an NS Basic/CE application instead."),TEXT("NS Basic/CE Runtime"),MB_OK);
			return false;
		}
	}

	if(!gbLaunching && !gbSquelchAutoLaunch) //we launched something
	{
		gbCloseOnEnd=true;
		gbShowEditorWindow=false;
	}

	if((gbLaunching || gbSquelchAutoLaunch) && gbShowEditorWindow)
	{//flag not flipped, so we didn't launch with a document.  Move the main window back on-screen
		gbLaunching = false;

		if (gszLastPath[0])
		{
			bool filePresent = true;
			HANDLE hFile=CreateFile(gszLastPath,GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if(hFile==INVALID_HANDLE_VALUE)
			{
				filePresent = false;
			}
			else
			{
				CloseHandle(hFile);
			}

			if (filePresent)
			{
				OpenDocumentFile(gszLastPath);
			}
			else
			{
				OnFileNew();
			}
		}
		else
		{
			OnFileNew();
		}
		m_pMainWnd->MoveWindow(&(((CMainFrame *)m_pMainWnd)->m_rectSavedBounds),true);
	}

	//**MARCH99 new BEGIN
	//we were launched with the magic document, so there's a chance another copy of NSB
	//was in front of us.  Move our window to the front.
	if(gbSquelchAutoLaunch)
		m_pMainWnd->ShowWindow(SW_SHOWNORMAL);

	if(gpCurrentDocument && gbSquelchAutoLaunch)
	{//we've loaded our "magic" temp file
		if(*gszRealFilename)
		{//put "real" filename into document
			gpCurrentDocument->SetPathName(gszRealFilename,false);
			gpCurrentDocument->SetDocumentTitle(gszRealFilename);
			
		}
		else if(*gszLastPath)
		{//put "real" filename into document
			gpCurrentDocument->SetPathName(gszLastPath,false);
			gpCurrentDocument->SetDocumentTitle(gszLastPath);
			
		}
		else
		{//nasty hack alert!  Need to simulate empty "new" document so the user doesn't
		 //see a save to our "magic" temp file..
			gpCurrentDocument->SetPathName(TEXT(" "),false); //can't set to empty string, because an assert will fail
			gpCurrentDocument->m_strPathName=TEXT(""); //this is a protected member, but we're a friend class (this is the hack)
			gpCurrentDocument->SetTitle(TEXT("")); //not sure why this is necessary, but otherwise the magic file name sticks around
			gpCurrentDocument->SetDocumentTitle(TEXT("untitled")); //set the window title
		}
		//mark the file as edited so the user will be prompted to save on exit.
		gpCurrentDocument->SetModifiedFlag(true);

		//no longer need the "real" filename..
		*gszRealFilename=0;
	}
	//**MARCH99 new END

	gbLaunching=false;
	// The one and only window has been initialized, so show and update it.
	//m_pMainWnd->ShowWindow(SW_SHOW);
	//m_pMainWnd->UpdateWindow();
	//m_pMainWnd->ShowWindow(SW_SHOWNOACTIVATE );
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg( CWnd *pParent = NULL );

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	//enum { IDD = IDD_ABOUTBOX };
	int IDD;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();		// Added for WCE apps
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg( CWnd *pParent ) : CDialog(
#ifdef _WIN32_WCE_PSPC
	IDD_ABOUTBOX_PPC, pParent
#else
	IDD_ABOUTBOX, pParent
#endif 
	)
{
#ifdef _WIN32_WCE_PSPC
	IDD = IDD_ABOUTBOX_PPC;
#else
	IDD = IDD_ABOUTBOX;
#endif
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
//DEL void CScriptApp::OnAppAbout()
//DEL {
//DEL 	CAboutDlg aboutDlg;
//DEL 	aboutDlg.DoModal();
//DEL }

/////////////////////////////////////////////////////////////////////////////
// CScriptApp commands
// Added for WCE apps

BOOL CAboutDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();
	CenterWindow();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAboutDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	RECT rectVersion;
	RECT rectMe;
	RECT rectDisclaimer;
	RECT rectSerial;

	TCHAR szText[]=L"Visit our web site at www.nsbasic.com\nFor support, send email to support@nsbasic.com\n-------------------------------------------\nWARNING: This computer program and its documentation are protected by copyright law and international treaties.  Unauthorized reproduction, use or distribution of this program, or any portion of it, may result in civil or criminal penalties and will be prosecuted to the maximum extent possible under the law.  Please see License Agreement in NS BASIC Handbook.";
	TCHAR szSerial[50];

	int iMode;
	CBrush cbrush;

	switch(gLaunchMode)
	{
	case LM_FULL :
		wsprintf(szSerial,TEXT("Serial #%s"),gszSerialNumber);
		break;
	case LM_RUNTIME:
		_tcscpy(szSerial,TEXT("(RUNTIME VERSION)"));
		break;
	case LM_DEMO:
		_tcscpy(szSerial,TEXT("(DEMO VERSION)"));
		break;
	}


	GetClientRect(&rectMe);


#if defined(_WIN32_WCE_PSPC)
	::SetRect(&rectVersion,rectMe.right-100,rectMe.bottom-15,rectMe.right,rectMe.bottom);
	::SetRect(&rectDisclaimer,rectMe.left+5,rectMe.top+50,rectMe.right-5,rectMe.bottom);
	::SetRect(&rectSerial,rectMe.left+2,rectMe.top+32,rectMe.left+125,rectMe.bottom);
#else
	::SetRect(&rectVersion,rectMe.right-100,rectMe.bottom-15,rectMe.right,rectMe.bottom);
	::SetRect(&rectDisclaimer,rectMe.left+20,rectMe.top+50,rectMe.right-20,rectMe.bottom);
	::SetRect(&rectSerial,rectMe.left+53,rectMe.top+32,rectMe.right-100,rectMe.bottom);
#endif
	//dc.FillRect(&rectVersion,cbrush.FromHandle((HBRUSH)::GetStockObject(BLACK_BRUSH)));
	iMode=dc.SetBkMode(TRANSPARENT);
	dc.DrawText(kVersionString,-1,&rectVersion,DT_RIGHT|DT_BOTTOM|DT_SINGLELINE);
	dc.DrawText(szText,-1,&rectDisclaimer,DT_LEFT|DT_TOP|DT_WORDBREAK);
	dc.DrawText(szSerial,-1,&rectSerial,DT_LEFT|DT_TOP);
	dc.SetBkMode(iMode);

	
	// Do not call CDialog::OnPaint() for painting messages
}

//**JULY99 - BEGIN FIX FOR CFileDialog type picker
//This function is used by DoPromptFileName
//ripped from CDocMgr
static void AFXAPI _AfxAppendFilterSuffix(CString& filter, OPENFILENAME& ofn,
	CDocTemplate* pTemplate, CString* pstrDefaultExt)
{
	ASSERT_VALID(pTemplate);
	ASSERT_KINDOF(CDocTemplate, pTemplate);

	CString strFilterExt, strFilterName;
	if (pTemplate->GetDocString(strFilterExt, CDocTemplate::filterExt) &&
	 !strFilterExt.IsEmpty() &&
	 pTemplate->GetDocString(strFilterName, CDocTemplate::filterName) &&
	 !strFilterName.IsEmpty())
	{
		// a file based document template - add to filter list
		ASSERT(strFilterExt[0] == '.');
		if (pstrDefaultExt != NULL)
		{
			// set the default extension
			*pstrDefaultExt = ((LPCTSTR)strFilterExt) + 1;  // skip the '.'
			ofn.lpstrDefExt = (LPTSTR)(LPCTSTR)(*pstrDefaultExt);
			ofn.nFilterIndex = ofn.nMaxCustFilter + 1;  // 1 based number
		}

		// add to filter
		filter += strFilterName;
		ASSERT(!filter.IsEmpty());  // must have a file type name
		filter += (TCHAR)'\0';  // next string please
		filter += (TCHAR)'*';
		filter += strFilterExt;
		filter += (TCHAR)'\0';  // next string please
		ofn.nMaxCustFilter++;
	}
}

//This class is necessary due to an apparent bug in some compilations of MFC.  In some
//cases (like on some HPC PRO devices), switching the file type in the picker and choosing
//a file will cause HELP to come up and the call to DoModal() never to return.  So,
//we just created our own class here and our own copy of DoModal (called myDoModal) which
//does exactly the same thing, except it works.. ;-)
class CMyFileDialog:public CFileDialog
{
public:
	int myDoModal(void);
	CMyFileDialog(BOOL b) ;
};

CMyFileDialog::CMyFileDialog(BOOL b):CFileDialog(b)
{//just delegate to the constructor in CFileDialog..
};

int CMyFileDialog::myDoModal()
{
	ASSERT_VALID(this);
#if !(defined(_WIN32_WCE_PSPC) && (_WIN32_WCE == 201))
// WinCE: lpfnHook field is not supported for PSPC
	ASSERT(m_ofn.Flags & OFN_ENABLEHOOK);
	ASSERT(m_ofn.lpfnHook != NULL); // can still be a user hook
#endif // _WIN32_WCE_PSPC

	// zero out the file buffer for consistent parsing later
	ASSERT(AfxIsValidAddress(m_ofn.lpstrFile, m_ofn.nMaxFile));
	DWORD nOffset = lstrlen(m_ofn.lpstrFile)+1;
	ASSERT(nOffset <= m_ofn.nMaxFile);
	memset(m_ofn.lpstrFile+nOffset, 0, (m_ofn.nMaxFile-nOffset)*sizeof(TCHAR));

	// WINBUG: This is a special case for the file open/save dialog,
	//  which sometimes pumps while it is coming up but before it has
	//  disabled the main window.
	HWND hWndFocus = ::GetFocus();
	BOOL bEnableParent = FALSE;
	m_ofn.hwndOwner = PreModal();
	AfxUnhookWindowCreate();
	if (m_ofn.hwndOwner != NULL && ::IsWindowEnabled(m_ofn.hwndOwner))
	{
		bEnableParent = TRUE;
		::EnableWindow(m_ofn.hwndOwner, FALSE);
	}

	_AFX_THREAD_STATE* pThreadState = AfxGetThreadState();
	ASSERT(pThreadState->m_pAlternateWndInit == NULL);

#if !defined(_WIN32_WCE)
	if (m_ofn.Flags & OFN_EXPLORER)
		pThreadState->m_pAlternateWndInit = this;
	else
		AfxHookWindowCreate(this);
#endif // _WIN32_WCE

	int nResult;
	if (m_bOpenFileDialog)
		nResult = ::GetOpenFileName(&m_ofn);
	else
		nResult = ::GetSaveFileName(&m_ofn);
#if defined(_WIN32_WCE_PSPC)
	// WinCE: By default (no choice in "Location" is selected), m_ofn.lpstrFile has
	// double slashes in front of it. Get rid of one if necessary.
	if (!m_bOpenFileDialog && (*m_ofn.lpstrFile == _T('\\')) && (*(m_ofn.lpstrFile+1) == _T('\\')))
		memmove((void*)m_ofn.lpstrFile, (void*)(m_ofn.lpstrFile + 1), _tcslen(m_ofn.lpstrFile)*sizeof(TCHAR)); 
#endif // _WIN32_WCE_PSPC

	if (nResult)
		ASSERT(pThreadState->m_pAlternateWndInit == NULL);
	pThreadState->m_pAlternateWndInit = NULL;

	// WINBUG: Second part of special case for file open/save dialog.
	if (bEnableParent)
		::EnableWindow(m_ofn.hwndOwner, TRUE);
	if (::IsWindow(hWndFocus))
		::SetFocus(hWndFocus);

	PostModal();
	return nResult ? nResult : IDCANCEL;
}

//This function is a specialization of the code originally found in CDocMgr::DoPromptFileName.
//normally, the CWinApp::DoPromptFileName immediately delegates to the version in CDocMgr.
//Instead of delegating, this version constructs the file dialog and adds an additional
//"text files" item to the "type" picker.  This is necessary because we don't actually have
//a document type for text files - we're just shoehorning in the type.  There are related
//fixes in CScriptDoc::DoSave and CScriptDoc::DoPromptFileName (which just delegates to this function)

BOOL CScriptApp::DoPromptFileName(CString& fileName, UINT nIDSTitle, DWORD lFlags, BOOL bOpenFileDialog, CDocTemplate* pTemplate)
{
	CMyFileDialog dlgFile(bOpenFileDialog);

	CString title;
	VERIFY(title.LoadString(nIDSTitle));

	dlgFile.m_ofn.Flags |= lFlags;

	CString strFilter;
	CString strDefault;
	if (pTemplate != NULL)
	{
		ASSERT_VALID(pTemplate);
		_AfxAppendFilterSuffix(strFilter, dlgFile.m_ofn, pTemplate, &strDefault);
	}
	else
	{
		// do for all doc template
		POSITION pos = m_pDocManager->GetFirstDocTemplatePosition(); //m_templateList.GetHeadPosition();
		BOOL bFirst = TRUE;
		while (pos != NULL)
		{
			//CDocTemplate* pTemplate = (CDocTemplate*)m_pDocManager->m_templateList.GetNext(pos);
			CDocTemplate* pTemplate = (CDocTemplate*)m_pDocManager->GetNextDocTemplate(pos);
			_AfxAppendFilterSuffix(strFilter, dlgFile.m_ofn, pTemplate,
				bFirst ? &strDefault : NULL);
			bFirst = FALSE;
		}
	}



	//add filter for text files
	strFilter += TEXT("Text Files (*.txt)");
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.txt");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	// append the "*.*" all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.*");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = fileName.GetBuffer(_MAX_PATH);

	int nResult = dlgFile.myDoModal();
	fileName.ReleaseBuffer();
	fileName.TrimRight();
	if(nResult==IDOK && !bOpenFileDialog)
	{//PPC fix to undo .txt.nsb extension
		if(fileName.Right(8).CompareNoCase(TEXT(".txt.nsb"))==0)
			fileName=fileName.Left(fileName.GetLength()-4);

	}
	return nResult == IDOK;
}


void CScriptApp::OnFileOpen() 
{
	// prompt the user (with all document templates)
	CString newName;
	if( !DoPromptFileName( newName, AFX_IDS_OPENFILE, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, TRUE, NULL ) )
		return; // open cancelled

	OpenDocumentFile(newName);
}
//**JULY99 - END FIX FOR CFileDialog type picker


#ifdef _POCKET
int AFXAPI AfxWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPTSTR lpCmdLine, int nCmdShow)
{
	//::MessageBox(NULL, L"Starting", L"EMP", MB_OK);
	ASSERT(hPrevInstance == NULL);

	int nReturnCode = -1;
	CWinThread* pThread = AfxGetThread();
	CWinApp* pApp = AfxGetApp();

	// AFX internal initialization
	if (!AfxWinInit(hInstance, hPrevInstance, lpCmdLine, nCmdShow))
		goto InitFailure;

	// App global initializations (rare)
	if (pApp != NULL && !pApp->InitApplication())
		goto InitFailure;

#if defined(_WIN32_WCE_PSPC) && (_WIN32_WCE >= 300)
	// WinCE: Only one application instance can be run
	HANDLE hMuTex;
	TCHAR szTempName[MAX_PATH], szExeName[MAX_PATH], szTempNsb[MAX_PATH];
	INT	i, iValue;
	FindAppT findApp;
	BOOL bGoAway;

	// NSB specific stuff
	findApp.pzNsbName = NULL;
	_tcscpy( szTempNsb, _T( "" ) );

	if( _tcslen( lpCmdLine ) > 0 )
	{ 
		// Only tricky if we've got a single argument
		TCHAR *psz, szTemp[MAX_PATH], szTemp2[MAX_PATH];
		if( _stscanf( lpCmdLine, _T("\"%[^\"]\" \"%[^\"]\""), szTemp, szTemp2 ) == 1 )
		{
			int len = _tcslen( szTemp );
			psz = szTemp + ( len - 4 );
			if( _tcsicmp( psz, _T(".nsb") ) == 0 ||
				_tcsicmp( psz, _T(".exe")) == 0)
			{
				// If it's not nsb file, let the shell handle our biz
				// Copy the single argument for our mutex
				_tcscpy( szTempNsb, szTemp );
				// Now chop the program name "\path\program.nsb" out
				*psz = _T('\0');
				// find last \ and copy from there
				psz = _tcsrchr( szTemp, _T('\\') );
				if( psz != NULL )
				{
					psz++;
					_tcscpy( szTemp, psz );
					findApp.pzNsbName = szTemp;
				}
			}
		}
	}
	// end specific

	iValue = ::GetModuleFileName( NULL, szExeName, MAX_PATH );

	// In case we're talking about a running .nsb file
	if( _tcslen( szTempNsb ) > 0 )
		_tcscpy( szTempName, szTempNsb );
	else
		_tcscpy( szTempName, _T("NS Basic,BASIC Editor") );

	for( i = 0; i < iValue; i++ )
	{
		if( szTempName[i] == '\\' )
			szTempName[i]='/';
	}

	hMuTex = ::CreateMutex(NULL, FALSE, szTempName);
	if( hMuTex != NULL )
	{
		if( ::GetLastError() == ERROR_ALREADY_EXISTS )
		{
//         ::MessageBeep( MB_ICONEXCLAMATION );
			bGoAway = FALSE;
//			memset( &findApp, 0, sizeof( FindAppT ) );
			findApp.hwnd = 0;
			findApp.pzExeName = (TCHAR *)szExeName;
//			findApp.pzNsbName = szTemp;

			iValue = pThread->GetThreadPriority();

			for( i = 0; i < STRIKENUM_MAX; i++ )
			{
				::EnumWindows( FindApplicationWindowProc, (LPARAM)&findApp );

				if( findApp.hwnd )
				{
					::SetForegroundWindow( (HWND)( ((DWORD)findApp.hwnd) | 0x01 ) );
					bGoAway = TRUE;
					break;
				}
				// wait for other app to finish starting or stopping
				pThread->SetThreadPriority( THREAD_PRIORITY_IDLE );
				Sleep( 1000 );    
				pThread->SetThreadPriority( iValue );
			}
			if( bGoAway ) 
				goto InitFailure;
		}
	}
#endif	

	// Perform specific initializations
	if (!pThread->InitInstance())
	{
		if (pThread->m_pMainWnd != NULL)
		{
			TRACE0("Warning: Destroying non-NULL m_pMainWnd\n");
			pThread->m_pMainWnd->DestroyWindow();
		}
		nReturnCode = pThread->ExitInstance();
		goto InitFailure;
	}
	nReturnCode = pThread->Run();

InitFailure:
#ifdef _DEBUG
	// Check for missing AfxLockTempMap calls
	if (AfxGetModuleThreadState()->m_nTempMapLock != 0)
	{
		TRACE1("Warning: Temp map lock count non-zero (%ld).\n",
			AfxGetModuleThreadState()->m_nTempMapLock);
	}
	AfxLockTempMaps();
	AfxUnlockTempMaps(-1);
#endif

	AfxWinTerm();

	return nReturnCode;
}
#endif

void CScriptApp::OnAppAbout() 
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

